/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.EndpointMessageResult;
import software.amazon.awssdk.services.pinpoint.model.MapOfMapOfEndpointMessageResultCopier;
import software.amazon.awssdk.services.pinpoint.transform.SendUsersMessageResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendUsersMessageResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, SendUsersMessageResponse> {
    private final String applicationId;
    private final String requestId;
    private final Map<String, Map<String, EndpointMessageResult>> result;

    private SendUsersMessageResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.requestId = builder.requestId;
        this.result = builder.result;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String requestId() {
        return this.requestId;
    }

    public Map<String, Map<String, EndpointMessageResult>> result() {
        return this.result;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendUsersMessageResponse)) {
            return false;
        }
        SendUsersMessageResponse other = (SendUsersMessageResponse)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.result(), other.result());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.requestId() != null) {
            sb.append("RequestId: ").append(this.requestId()).append(",");
        }
        if (this.result() != null) {
            sb.append("Result: ").append(this.result()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "RequestId": {
                return Optional.of(clazz.cast(this.requestId()));
            }
            case "Result": {
                return Optional.of(clazz.cast(this.result()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SendUsersMessageResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String requestId;
        private Map<String, Map<String, EndpointMessageResult>> result;

        private BuilderImpl() {
        }

        private BuilderImpl(SendUsersMessageResponse model) {
            this.applicationId(model.applicationId);
            this.requestId(model.requestId);
            this.result(model.result);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Map<String, Map<String, EndpointMessageResult>> getResult() {
            return this.result;
        }

        @Override
        public final Builder result(Map<String, Map<String, EndpointMessageResult>> result) {
            this.result = MapOfMapOfEndpointMessageResultCopier.copy(result);
            return this;
        }

        public final void setResult(Map<String, Map<String, EndpointMessageResult>> result) {
            this.result = MapOfMapOfEndpointMessageResultCopier.copy(result);
        }

        public SendUsersMessageResponse build() {
            return new SendUsersMessageResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendUsersMessageResponse> {
        public Builder applicationId(String var1);

        public Builder requestId(String var1);

        public Builder result(Map<String, Map<String, EndpointMessageResult>> var1);
    }
}

