/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.EndpointUserMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EndpointUser
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointUser> {
    private final Map<String, List<String>> userAttributes;
    private final String userId;

    private EndpointUser(BuilderImpl builder) {
        this.userAttributes = builder.userAttributes;
        this.userId = builder.userId;
    }

    public Map<String, List<String>> userAttributes() {
        return this.userAttributes;
    }

    public String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointUser)) {
            return false;
        }
        EndpointUser other = (EndpointUser)obj;
        return Objects.equals(this.userAttributes(), other.userAttributes()) && Objects.equals(this.userId(), other.userId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userAttributes() != null) {
            sb.append("UserAttributes: ").append(this.userAttributes()).append(",");
        }
        if (this.userId() != null) {
            sb.append("UserId: ").append(this.userId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserAttributes": {
                return Optional.of(clazz.cast(this.userAttributes()));
            }
            case "UserId": {
                return Optional.of(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointUserMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<String>> userAttributes;
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointUser model) {
            this.userAttributes(model.userAttributes);
            this.userId(model.userId);
        }

        public final Map<String, ? extends Collection<String>> getUserAttributes() {
            return this.userAttributes;
        }

        @Override
        public final Builder userAttributes(Map<String, ? extends Collection<String>> userAttributes) {
            this.userAttributes = MapOfListOf__stringCopier.copy(userAttributes);
            return this;
        }

        public final void setUserAttributes(Map<String, ? extends Collection<String>> userAttributes) {
            this.userAttributes = MapOfListOf__stringCopier.copy(userAttributes);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public EndpointUser build() {
            return new EndpointUser(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointUser> {
        public Builder userAttributes(Map<String, ? extends Collection<String>> var1);

        public Builder userId(String var1);
    }
}

