/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.ChannelType;
import software.amazon.awssdk.services.pinpoint.model.EndpointDemographic;
import software.amazon.awssdk.services.pinpoint.model.EndpointLocation;
import software.amazon.awssdk.services.pinpoint.model.EndpointUser;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__doubleCopier;
import software.amazon.awssdk.services.pinpoint.transform.EndpointResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EndpointResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointResponse> {
    private final String address;
    private final String applicationId;
    private final Map<String, List<String>> attributes;
    private final String channelType;
    private final String cohortId;
    private final String creationDate;
    private final EndpointDemographic demographic;
    private final String effectiveDate;
    private final String endpointStatus;
    private final String id;
    private final EndpointLocation location;
    private final Map<String, Double> metrics;
    private final String optOut;
    private final String requestId;
    private final EndpointUser user;

    private EndpointResponse(BuilderImpl builder) {
        this.address = builder.address;
        this.applicationId = builder.applicationId;
        this.attributes = builder.attributes;
        this.channelType = builder.channelType;
        this.cohortId = builder.cohortId;
        this.creationDate = builder.creationDate;
        this.demographic = builder.demographic;
        this.effectiveDate = builder.effectiveDate;
        this.endpointStatus = builder.endpointStatus;
        this.id = builder.id;
        this.location = builder.location;
        this.metrics = builder.metrics;
        this.optOut = builder.optOut;
        this.requestId = builder.requestId;
        this.user = builder.user;
    }

    public String address() {
        return this.address;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public Map<String, List<String>> attributes() {
        return this.attributes;
    }

    public ChannelType channelType() {
        return ChannelType.fromValue(this.channelType);
    }

    public String channelTypeString() {
        return this.channelType;
    }

    public String cohortId() {
        return this.cohortId;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public EndpointDemographic demographic() {
        return this.demographic;
    }

    public String effectiveDate() {
        return this.effectiveDate;
    }

    public String endpointStatus() {
        return this.endpointStatus;
    }

    public String id() {
        return this.id;
    }

    public EndpointLocation location() {
        return this.location;
    }

    public Map<String, Double> metrics() {
        return this.metrics;
    }

    public String optOut() {
        return this.optOut;
    }

    public String requestId() {
        return this.requestId;
    }

    public EndpointUser user() {
        return this.user;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cohortId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.demographic());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.optOut());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointResponse)) {
            return false;
        }
        EndpointResponse other = (EndpointResponse)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.channelTypeString(), other.channelTypeString()) && Objects.equals(this.cohortId(), other.cohortId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.demographic(), other.demographic()) && Objects.equals(this.effectiveDate(), other.effectiveDate()) && Objects.equals(this.endpointStatus(), other.endpointStatus()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.optOut(), other.optOut()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.user(), other.user());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.address() != null) {
            sb.append("Address: ").append(this.address()).append(",");
        }
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.channelTypeString() != null) {
            sb.append("ChannelType: ").append(this.channelTypeString()).append(",");
        }
        if (this.cohortId() != null) {
            sb.append("CohortId: ").append(this.cohortId()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.demographic() != null) {
            sb.append("Demographic: ").append(this.demographic()).append(",");
        }
        if (this.effectiveDate() != null) {
            sb.append("EffectiveDate: ").append(this.effectiveDate()).append(",");
        }
        if (this.endpointStatus() != null) {
            sb.append("EndpointStatus: ").append(this.endpointStatus()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.metrics() != null) {
            sb.append("Metrics: ").append(this.metrics()).append(",");
        }
        if (this.optOut() != null) {
            sb.append("OptOut: ").append(this.optOut()).append(",");
        }
        if (this.requestId() != null) {
            sb.append("RequestId: ").append(this.requestId()).append(",");
        }
        if (this.user() != null) {
            sb.append("User: ").append(this.user()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Address": {
                return Optional.of(clazz.cast(this.address()));
            }
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
            case "ChannelType": {
                return Optional.of(clazz.cast(this.channelTypeString()));
            }
            case "CohortId": {
                return Optional.of(clazz.cast(this.cohortId()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "Demographic": {
                return Optional.of(clazz.cast(this.demographic()));
            }
            case "EffectiveDate": {
                return Optional.of(clazz.cast(this.effectiveDate()));
            }
            case "EndpointStatus": {
                return Optional.of(clazz.cast(this.endpointStatus()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "Metrics": {
                return Optional.of(clazz.cast(this.metrics()));
            }
            case "OptOut": {
                return Optional.of(clazz.cast(this.optOut()));
            }
            case "RequestId": {
                return Optional.of(clazz.cast(this.requestId()));
            }
            case "User": {
                return Optional.of(clazz.cast(this.user()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String address;
        private String applicationId;
        private Map<String, List<String>> attributes;
        private String channelType;
        private String cohortId;
        private String creationDate;
        private EndpointDemographic demographic;
        private String effectiveDate;
        private String endpointStatus;
        private String id;
        private EndpointLocation location;
        private Map<String, Double> metrics;
        private String optOut;
        private String requestId;
        private EndpointUser user;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointResponse model) {
            this.address(model.address);
            this.applicationId(model.applicationId);
            this.attributes(model.attributes);
            this.channelType(model.channelType);
            this.cohortId(model.cohortId);
            this.creationDate(model.creationDate);
            this.demographic(model.demographic);
            this.effectiveDate(model.effectiveDate);
            this.endpointStatus(model.endpointStatus);
            this.id(model.id);
            this.location(model.location);
            this.metrics(model.metrics);
            this.optOut(model.optOut);
            this.requestId(model.requestId);
            this.user(model.user);
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Map<String, ? extends Collection<String>> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, ? extends Collection<String>> attributes) {
            this.attributes = MapOfListOf__stringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, ? extends Collection<String>> attributes) {
            this.attributes = MapOfListOf__stringCopier.copy(attributes);
        }

        public final String getChannelType() {
            return this.channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType.toString());
            return this;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        public final String getCohortId() {
            return this.cohortId;
        }

        @Override
        public final Builder cohortId(String cohortId) {
            this.cohortId = cohortId;
            return this;
        }

        public final void setCohortId(String cohortId) {
            this.cohortId = cohortId;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final EndpointDemographic.Builder getDemographic() {
            return this.demographic != null ? this.demographic.toBuilder() : null;
        }

        @Override
        public final Builder demographic(EndpointDemographic demographic) {
            this.demographic = demographic;
            return this;
        }

        public final void setDemographic(EndpointDemographic.BuilderImpl demographic) {
            this.demographic = demographic != null ? demographic.build() : null;
        }

        public final String getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public final Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final void setEffectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        public final String getEndpointStatus() {
            return this.endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final EndpointLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(EndpointLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(EndpointLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final Map<String, Double> getMetrics() {
            return this.metrics;
        }

        @Override
        public final Builder metrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
            return this;
        }

        public final void setMetrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
        }

        public final String getOptOut() {
            return this.optOut;
        }

        @Override
        public final Builder optOut(String optOut) {
            this.optOut = optOut;
            return this;
        }

        public final void setOptOut(String optOut) {
            this.optOut = optOut;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final EndpointUser.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        @Override
        public final Builder user(EndpointUser user) {
            this.user = user;
            return this;
        }

        public final void setUser(EndpointUser.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        public EndpointResponse build() {
            return new EndpointResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointResponse> {
        public Builder address(String var1);

        public Builder applicationId(String var1);

        public Builder attributes(Map<String, ? extends Collection<String>> var1);

        public Builder channelType(String var1);

        public Builder channelType(ChannelType var1);

        public Builder cohortId(String var1);

        public Builder creationDate(String var1);

        public Builder demographic(EndpointDemographic var1);

        default public Builder demographic(Consumer<EndpointDemographic.Builder> demographic) {
            return this.demographic((EndpointDemographic)((EndpointDemographic.Builder)EndpointDemographic.builder().apply(demographic)).build());
        }

        public Builder effectiveDate(String var1);

        public Builder endpointStatus(String var1);

        public Builder id(String var1);

        public Builder location(EndpointLocation var1);

        default public Builder location(Consumer<EndpointLocation.Builder> location) {
            return this.location((EndpointLocation)((EndpointLocation.Builder)EndpointLocation.builder().apply(location)).build());
        }

        public Builder metrics(Map<String, Double> var1);

        public Builder optOut(String var1);

        public Builder requestId(String var1);

        public Builder user(EndpointUser var1);

        default public Builder user(Consumer<EndpointUser.Builder> user) {
            return this.user((EndpointUser)((EndpointUser.Builder)EndpointUser.builder().apply(user)).build());
        }
    }
}

