/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.EndpointBatchItem;
import software.amazon.awssdk.services.pinpoint.model.ListOfEndpointBatchItemCopier;
import software.amazon.awssdk.services.pinpoint.transform.EndpointBatchRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EndpointBatchRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointBatchRequest> {
    private final List<EndpointBatchItem> item;

    private EndpointBatchRequest(BuilderImpl builder) {
        this.item = builder.item;
    }

    public List<EndpointBatchItem> item() {
        return this.item;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointBatchRequest)) {
            return false;
        }
        EndpointBatchRequest other = (EndpointBatchRequest)obj;
        return Objects.equals(this.item(), other.item());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.item() != null) {
            sb.append("Item: ").append(this.item()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.of(clazz.cast(this.item()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointBatchRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EndpointBatchItem> item;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointBatchRequest model) {
            this.item(model.item);
        }

        public final Collection<EndpointBatchItem.Builder> getItem() {
            return this.item != null ? (Collection)this.item.stream().map(EndpointBatchItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<EndpointBatchItem> item) {
            this.item = ListOfEndpointBatchItemCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(EndpointBatchItem ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        public final void setItem(Collection<EndpointBatchItem.BuilderImpl> item) {
            this.item = ListOfEndpointBatchItemCopier.copyFromBuilder(item);
        }

        public EndpointBatchRequest build() {
            return new EndpointBatchRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointBatchRequest> {
        public Builder item(Collection<EndpointBatchItem> var1);

        public Builder item(EndpointBatchItem ... var1);
    }
}

