/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.CampaignLimitsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CampaignLimits
implements StructuredPojo,
ToCopyableBuilder<Builder, CampaignLimits> {
    private final Integer daily;
    private final Integer maximumDuration;
    private final Integer messagesPerSecond;
    private final Integer total;

    private CampaignLimits(BuilderImpl builder) {
        this.daily = builder.daily;
        this.maximumDuration = builder.maximumDuration;
        this.messagesPerSecond = builder.messagesPerSecond;
        this.total = builder.total;
    }

    public Integer daily() {
        return this.daily;
    }

    public Integer maximumDuration() {
        return this.maximumDuration;
    }

    public Integer messagesPerSecond() {
        return this.messagesPerSecond;
    }

    public Integer total() {
        return this.total;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.daily());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.messagesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignLimits)) {
            return false;
        }
        CampaignLimits other = (CampaignLimits)obj;
        return Objects.equals(this.daily(), other.daily()) && Objects.equals(this.maximumDuration(), other.maximumDuration()) && Objects.equals(this.messagesPerSecond(), other.messagesPerSecond()) && Objects.equals(this.total(), other.total());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.daily() != null) {
            sb.append("Daily: ").append(this.daily()).append(",");
        }
        if (this.maximumDuration() != null) {
            sb.append("MaximumDuration: ").append(this.maximumDuration()).append(",");
        }
        if (this.messagesPerSecond() != null) {
            sb.append("MessagesPerSecond: ").append(this.messagesPerSecond()).append(",");
        }
        if (this.total() != null) {
            sb.append("Total: ").append(this.total()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Daily": {
                return Optional.of(clazz.cast(this.daily()));
            }
            case "MaximumDuration": {
                return Optional.of(clazz.cast(this.maximumDuration()));
            }
            case "MessagesPerSecond": {
                return Optional.of(clazz.cast(this.messagesPerSecond()));
            }
            case "Total": {
                return Optional.of(clazz.cast(this.total()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CampaignLimitsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer daily;
        private Integer maximumDuration;
        private Integer messagesPerSecond;
        private Integer total;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignLimits model) {
            this.daily(model.daily);
            this.maximumDuration(model.maximumDuration);
            this.messagesPerSecond(model.messagesPerSecond);
            this.total(model.total);
        }

        public final Integer getDaily() {
            return this.daily;
        }

        @Override
        public final Builder daily(Integer daily) {
            this.daily = daily;
            return this;
        }

        public final void setDaily(Integer daily) {
            this.daily = daily;
        }

        public final Integer getMaximumDuration() {
            return this.maximumDuration;
        }

        @Override
        public final Builder maximumDuration(Integer maximumDuration) {
            this.maximumDuration = maximumDuration;
            return this;
        }

        public final void setMaximumDuration(Integer maximumDuration) {
            this.maximumDuration = maximumDuration;
        }

        public final Integer getMessagesPerSecond() {
            return this.messagesPerSecond;
        }

        @Override
        public final Builder messagesPerSecond(Integer messagesPerSecond) {
            this.messagesPerSecond = messagesPerSecond;
            return this;
        }

        public final void setMessagesPerSecond(Integer messagesPerSecond) {
            this.messagesPerSecond = messagesPerSecond;
        }

        public final Integer getTotal() {
            return this.total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        public CampaignLimits build() {
            return new CampaignLimits(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CampaignLimits> {
        public Builder daily(Integer var1);

        public Builder maximumDuration(Integer var1);

        public Builder messagesPerSecond(Integer var1);

        public Builder total(Integer var1);
    }
}

