/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.EndpointResponse;
import software.amazon.awssdk.services.pinpoint.transform.EndpointDemographicUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.EndpointLocationUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.EndpointUserUnmarshaller;

public class EndpointResponseUnmarshaller
implements Unmarshaller<EndpointResponse, JsonUnmarshallerContext> {
    private static final EndpointResponseUnmarshaller INSTANCE = new EndpointResponseUnmarshaller();

    public EndpointResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        EndpointResponse.Builder endpointResponseBuilder = EndpointResponse.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Address", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.address((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ApplicationId", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.applicationId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.attributes(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("ChannelType", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.channelType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CohortId", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.cohortId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.creationDate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Demographic", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.demographic(EndpointDemographicUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("EffectiveDate", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.effectiveDate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EndpointStatus", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.endpointStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Location", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.location(EndpointLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Metrics", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.metrics(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(Double.class)).unmarshall(context));
                }
                if (context.testExpression("OptOut", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.optOut((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RequestId", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.requestId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("User", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.user(EndpointUserUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ShardId", targetDepth)) {
                    context.nextToken();
                    endpointResponseBuilder.shardId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EndpointResponse)endpointResponseBuilder.build();
    }

    public static EndpointResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

