/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest;

@SdkInternalApi
public class APNSChannelRequestMarshaller {
    private static final MarshallingInfo<String> CERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Certificate").build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<String> PRIVATEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateKey").build();
    private static final APNSChannelRequestMarshaller INSTANCE = new APNSChannelRequestMarshaller();

    public static APNSChannelRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(APNSChannelRequest apnsChannelRequest, ProtocolMarshaller protocolMarshaller) {
        if (apnsChannelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)apnsChannelRequest.certificate(), CERTIFICATE_BINDING);
            protocolMarshaller.marshall((Object)apnsChannelRequest.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)apnsChannelRequest.privateKey(), PRIVATEKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

