/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.WriteEventStreamMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WriteEventStream
implements StructuredPojo,
ToCopyableBuilder<Builder, WriteEventStream> {
    private final String destinationStreamArn;
    private final String externalId;
    private final String roleArn;

    private WriteEventStream(BuilderImpl builder) {
        this.destinationStreamArn = builder.destinationStreamArn;
        this.externalId = builder.externalId;
        this.roleArn = builder.roleArn;
    }

    public String destinationStreamArn() {
        return this.destinationStreamArn;
    }

    public String externalId() {
        return this.externalId;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.destinationStreamArn() == null ? 0 : this.destinationStreamArn().hashCode());
        hashCode = 31 * hashCode + (this.externalId() == null ? 0 : this.externalId().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteEventStream)) {
            return false;
        }
        WriteEventStream other = (WriteEventStream)obj;
        if (other.destinationStreamArn() == null ^ this.destinationStreamArn() == null) {
            return false;
        }
        if (other.destinationStreamArn() != null && !other.destinationStreamArn().equals(this.destinationStreamArn())) {
            return false;
        }
        if (other.externalId() == null ^ this.externalId() == null) {
            return false;
        }
        if (other.externalId() != null && !other.externalId().equals(this.externalId())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        return other.roleArn() == null || other.roleArn().equals(this.roleArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.destinationStreamArn() != null) {
            sb.append("DestinationStreamArn: ").append(this.destinationStreamArn()).append(",");
        }
        if (this.externalId() != null) {
            sb.append("ExternalId: ").append(this.externalId()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationStreamArn": {
                return Optional.of(clazz.cast(this.destinationStreamArn()));
            }
            case "ExternalId": {
                return Optional.of(clazz.cast(this.externalId()));
            }
            case "RoleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteEventStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationStreamArn;
        private String externalId;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteEventStream model) {
            this.destinationStreamArn(model.destinationStreamArn);
            this.externalId(model.externalId);
            this.roleArn(model.roleArn);
        }

        public final String getDestinationStreamArn() {
            return this.destinationStreamArn;
        }

        @Override
        public final Builder destinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
            return this;
        }

        public final void setDestinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public WriteEventStream build() {
            return new WriteEventStream(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WriteEventStream> {
        public Builder destinationStreamArn(String var1);

        public Builder externalId(String var1);

        public Builder roleArn(String var1);
    }
}

