/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.ListOfWriteTreatmentResourceCopier;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.Schedule;
import software.amazon.awssdk.services.pinpoint.model.WriteTreatmentResource;
import software.amazon.awssdk.services.pinpoint.transform.WriteCampaignRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WriteCampaignRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, WriteCampaignRequest> {
    private final List<WriteTreatmentResource> additionalTreatments;
    private final String description;
    private final Integer holdoutPercent;
    private final Boolean isPaused;
    private final CampaignLimits limits;
    private final MessageConfiguration messageConfiguration;
    private final String name;
    private final Schedule schedule;
    private final String segmentId;
    private final Integer segmentVersion;
    private final String treatmentDescription;
    private final String treatmentName;

    private WriteCampaignRequest(BuilderImpl builder) {
        this.additionalTreatments = builder.additionalTreatments;
        this.description = builder.description;
        this.holdoutPercent = builder.holdoutPercent;
        this.isPaused = builder.isPaused;
        this.limits = builder.limits;
        this.messageConfiguration = builder.messageConfiguration;
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
    }

    public List<WriteTreatmentResource> additionalTreatments() {
        return this.additionalTreatments;
    }

    public String description() {
        return this.description;
    }

    public Integer holdoutPercent() {
        return this.holdoutPercent;
    }

    public Boolean isPaused() {
        return this.isPaused;
    }

    public CampaignLimits limits() {
        return this.limits;
    }

    public MessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public String name() {
        return this.name;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public Integer segmentVersion() {
        return this.segmentVersion;
    }

    public String treatmentDescription() {
        return this.treatmentDescription;
    }

    public String treatmentName() {
        return this.treatmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.additionalTreatments() == null ? 0 : this.additionalTreatments().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.holdoutPercent() == null ? 0 : this.holdoutPercent().hashCode());
        hashCode = 31 * hashCode + (this.isPaused() == null ? 0 : this.isPaused().hashCode());
        hashCode = 31 * hashCode + (this.limits() == null ? 0 : this.limits().hashCode());
        hashCode = 31 * hashCode + (this.messageConfiguration() == null ? 0 : this.messageConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.schedule() == null ? 0 : this.schedule().hashCode());
        hashCode = 31 * hashCode + (this.segmentId() == null ? 0 : this.segmentId().hashCode());
        hashCode = 31 * hashCode + (this.segmentVersion() == null ? 0 : this.segmentVersion().hashCode());
        hashCode = 31 * hashCode + (this.treatmentDescription() == null ? 0 : this.treatmentDescription().hashCode());
        hashCode = 31 * hashCode + (this.treatmentName() == null ? 0 : this.treatmentName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteCampaignRequest)) {
            return false;
        }
        WriteCampaignRequest other = (WriteCampaignRequest)obj;
        if (other.additionalTreatments() == null ^ this.additionalTreatments() == null) {
            return false;
        }
        if (other.additionalTreatments() != null && !other.additionalTreatments().equals(this.additionalTreatments())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.holdoutPercent() == null ^ this.holdoutPercent() == null) {
            return false;
        }
        if (other.holdoutPercent() != null && !other.holdoutPercent().equals(this.holdoutPercent())) {
            return false;
        }
        if (other.isPaused() == null ^ this.isPaused() == null) {
            return false;
        }
        if (other.isPaused() != null && !other.isPaused().equals(this.isPaused())) {
            return false;
        }
        if (other.limits() == null ^ this.limits() == null) {
            return false;
        }
        if (other.limits() != null && !other.limits().equals(this.limits())) {
            return false;
        }
        if (other.messageConfiguration() == null ^ this.messageConfiguration() == null) {
            return false;
        }
        if (other.messageConfiguration() != null && !other.messageConfiguration().equals(this.messageConfiguration())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.schedule() == null ^ this.schedule() == null) {
            return false;
        }
        if (other.schedule() != null && !other.schedule().equals(this.schedule())) {
            return false;
        }
        if (other.segmentId() == null ^ this.segmentId() == null) {
            return false;
        }
        if (other.segmentId() != null && !other.segmentId().equals(this.segmentId())) {
            return false;
        }
        if (other.segmentVersion() == null ^ this.segmentVersion() == null) {
            return false;
        }
        if (other.segmentVersion() != null && !other.segmentVersion().equals(this.segmentVersion())) {
            return false;
        }
        if (other.treatmentDescription() == null ^ this.treatmentDescription() == null) {
            return false;
        }
        if (other.treatmentDescription() != null && !other.treatmentDescription().equals(this.treatmentDescription())) {
            return false;
        }
        if (other.treatmentName() == null ^ this.treatmentName() == null) {
            return false;
        }
        return other.treatmentName() == null || other.treatmentName().equals(this.treatmentName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.additionalTreatments() != null) {
            sb.append("AdditionalTreatments: ").append(this.additionalTreatments()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.holdoutPercent() != null) {
            sb.append("HoldoutPercent: ").append(this.holdoutPercent()).append(",");
        }
        if (this.isPaused() != null) {
            sb.append("IsPaused: ").append(this.isPaused()).append(",");
        }
        if (this.limits() != null) {
            sb.append("Limits: ").append(this.limits()).append(",");
        }
        if (this.messageConfiguration() != null) {
            sb.append("MessageConfiguration: ").append(this.messageConfiguration()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.schedule() != null) {
            sb.append("Schedule: ").append(this.schedule()).append(",");
        }
        if (this.segmentId() != null) {
            sb.append("SegmentId: ").append(this.segmentId()).append(",");
        }
        if (this.segmentVersion() != null) {
            sb.append("SegmentVersion: ").append(this.segmentVersion()).append(",");
        }
        if (this.treatmentDescription() != null) {
            sb.append("TreatmentDescription: ").append(this.treatmentDescription()).append(",");
        }
        if (this.treatmentName() != null) {
            sb.append("TreatmentName: ").append(this.treatmentName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalTreatments": {
                return Optional.of(clazz.cast(this.additionalTreatments()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "HoldoutPercent": {
                return Optional.of(clazz.cast(this.holdoutPercent()));
            }
            case "IsPaused": {
                return Optional.of(clazz.cast(this.isPaused()));
            }
            case "Limits": {
                return Optional.of(clazz.cast(this.limits()));
            }
            case "MessageConfiguration": {
                return Optional.of(clazz.cast(this.messageConfiguration()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Schedule": {
                return Optional.of(clazz.cast(this.schedule()));
            }
            case "SegmentId": {
                return Optional.of(clazz.cast(this.segmentId()));
            }
            case "SegmentVersion": {
                return Optional.of(clazz.cast(this.segmentVersion()));
            }
            case "TreatmentDescription": {
                return Optional.of(clazz.cast(this.treatmentDescription()));
            }
            case "TreatmentName": {
                return Optional.of(clazz.cast(this.treatmentName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteCampaignRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<WriteTreatmentResource> additionalTreatments;
        private String description;
        private Integer holdoutPercent;
        private Boolean isPaused;
        private CampaignLimits limits;
        private MessageConfiguration messageConfiguration;
        private String name;
        private Schedule schedule;
        private String segmentId;
        private Integer segmentVersion;
        private String treatmentDescription;
        private String treatmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteCampaignRequest model) {
            this.additionalTreatments(model.additionalTreatments);
            this.description(model.description);
            this.holdoutPercent(model.holdoutPercent);
            this.isPaused(model.isPaused);
            this.limits(model.limits);
            this.messageConfiguration(model.messageConfiguration);
            this.name(model.name);
            this.schedule(model.schedule);
            this.segmentId(model.segmentId);
            this.segmentVersion(model.segmentVersion);
            this.treatmentDescription(model.treatmentDescription);
            this.treatmentName(model.treatmentName);
        }

        public final Collection<WriteTreatmentResource.Builder> getAdditionalTreatments() {
            return this.additionalTreatments != null ? (Collection)this.additionalTreatments.stream().map(WriteTreatmentResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalTreatments(Collection<WriteTreatmentResource> additionalTreatments) {
            this.additionalTreatments = ListOfWriteTreatmentResourceCopier.copy(additionalTreatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(WriteTreatmentResource ... additionalTreatments) {
            this.additionalTreatments(Arrays.asList(additionalTreatments));
            return this;
        }

        public final void setAdditionalTreatments(Collection<WriteTreatmentResource.BuilderImpl> additionalTreatments) {
            this.additionalTreatments = ListOfWriteTreatmentResourceCopier.copyFromBuilder(additionalTreatments);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getHoldoutPercent() {
            return this.holdoutPercent;
        }

        @Override
        public final Builder holdoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
            return this;
        }

        public final void setHoldoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
        }

        public final Boolean getIsPaused() {
            return this.isPaused;
        }

        @Override
        public final Builder isPaused(Boolean isPaused) {
            this.isPaused = isPaused;
            return this;
        }

        public final void setIsPaused(Boolean isPaused) {
            this.isPaused = isPaused;
        }

        public final CampaignLimits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final Integer getSegmentVersion() {
            return this.segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        public final String getTreatmentDescription() {
            return this.treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        public WriteCampaignRequest build() {
            return new WriteCampaignRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WriteCampaignRequest> {
        public Builder additionalTreatments(Collection<WriteTreatmentResource> var1);

        public Builder additionalTreatments(WriteTreatmentResource ... var1);

        public Builder description(String var1);

        public Builder holdoutPercent(Integer var1);

        public Builder isPaused(Boolean var1);

        public Builder limits(CampaignLimits var1);

        public Builder messageConfiguration(MessageConfiguration var1);

        public Builder name(String var1);

        public Builder schedule(Schedule var1);

        public Builder segmentId(String var1);

        public Builder segmentVersion(Integer var1);

        public Builder treatmentDescription(String var1);

        public Builder treatmentName(String var1);
    }
}

