/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateEmailChannelRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateEmailChannelRequest> {
    private final String applicationId;
    private final EmailChannelRequest emailChannelRequest;

    private UpdateEmailChannelRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.emailChannelRequest = builder.emailChannelRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public EmailChannelRequest emailChannelRequest() {
        return this.emailChannelRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.emailChannelRequest() == null ? 0 : this.emailChannelRequest().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEmailChannelRequest)) {
            return false;
        }
        UpdateEmailChannelRequest other = (UpdateEmailChannelRequest)((Object)obj);
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.emailChannelRequest() == null ^ this.emailChannelRequest() == null) {
            return false;
        }
        return other.emailChannelRequest() == null || other.emailChannelRequest().equals(this.emailChannelRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.emailChannelRequest() != null) {
            sb.append("EmailChannelRequest: ").append(this.emailChannelRequest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "EmailChannelRequest": {
                return Optional.of(clazz.cast(this.emailChannelRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private EmailChannelRequest emailChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEmailChannelRequest model) {
            this.applicationId(model.applicationId);
            this.emailChannelRequest(model.emailChannelRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final EmailChannelRequest.Builder getEmailChannelRequest() {
            return this.emailChannelRequest != null ? this.emailChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder emailChannelRequest(EmailChannelRequest emailChannelRequest) {
            this.emailChannelRequest = emailChannelRequest;
            return this;
        }

        public final void setEmailChannelRequest(EmailChannelRequest.BuilderImpl emailChannelRequest) {
            this.emailChannelRequest = emailChannelRequest != null ? emailChannelRequest.build() : null;
        }

        public UpdateEmailChannelRequest build() {
            return new UpdateEmailChannelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateEmailChannelRequest> {
        public Builder applicationId(String var1);

        public Builder emailChannelRequest(EmailChannelRequest var1);
    }
}

