/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateApnsChannelRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateApnsChannelRequest> {
    private final APNSChannelRequest apnsChannelRequest;
    private final String applicationId;

    private UpdateApnsChannelRequest(BuilderImpl builder) {
        this.apnsChannelRequest = builder.apnsChannelRequest;
        this.applicationId = builder.applicationId;
    }

    public APNSChannelRequest apnsChannelRequest() {
        return this.apnsChannelRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.apnsChannelRequest() == null ? 0 : this.apnsChannelRequest().hashCode());
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApnsChannelRequest)) {
            return false;
        }
        UpdateApnsChannelRequest other = (UpdateApnsChannelRequest)((Object)obj);
        if (other.apnsChannelRequest() == null ^ this.apnsChannelRequest() == null) {
            return false;
        }
        if (other.apnsChannelRequest() != null && !other.apnsChannelRequest().equals(this.apnsChannelRequest())) {
            return false;
        }
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        return other.applicationId() == null || other.applicationId().equals(this.applicationId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.apnsChannelRequest() != null) {
            sb.append("APNSChannelRequest: ").append(this.apnsChannelRequest()).append(",");
        }
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "APNSChannelRequest": {
                return Optional.of(clazz.cast(this.apnsChannelRequest()));
            }
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private APNSChannelRequest apnsChannelRequest;
        private String applicationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApnsChannelRequest model) {
            this.apnsChannelRequest(model.apnsChannelRequest);
            this.applicationId(model.applicationId);
        }

        public final APNSChannelRequest.Builder getAPNSChannelRequest() {
            return this.apnsChannelRequest != null ? this.apnsChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder apnsChannelRequest(APNSChannelRequest apnsChannelRequest) {
            this.apnsChannelRequest = apnsChannelRequest;
            return this;
        }

        public final void setAPNSChannelRequest(APNSChannelRequest.BuilderImpl apnsChannelRequest) {
            this.apnsChannelRequest = apnsChannelRequest != null ? apnsChannelRequest.build() : null;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public UpdateApnsChannelRequest build() {
            return new UpdateApnsChannelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateApnsChannelRequest> {
        public Builder apnsChannelRequest(APNSChannelRequest var1);

        public Builder applicationId(String var1);
    }
}

