/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetCampaignVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetCampaignVersionRequest> {
    private final String applicationId;
    private final String campaignId;
    private final String version;

    private GetCampaignVersionRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.campaignId = builder.campaignId;
        this.version = builder.version;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String campaignId() {
        return this.campaignId;
    }

    public String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.campaignId() == null ? 0 : this.campaignId().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCampaignVersionRequest)) {
            return false;
        }
        GetCampaignVersionRequest other = (GetCampaignVersionRequest)((Object)obj);
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.campaignId() == null ^ this.campaignId() == null) {
            return false;
        }
        if (other.campaignId() != null && !other.campaignId().equals(this.campaignId())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        return other.version() == null || other.version().equals(this.version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.campaignId() != null) {
            sb.append("CampaignId: ").append(this.campaignId()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "CampaignId": {
                return Optional.of(clazz.cast(this.campaignId()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String campaignId;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCampaignVersionRequest model) {
            this.applicationId(model.applicationId);
            this.campaignId(model.campaignId);
            this.version(model.version);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCampaignId() {
            return this.campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public GetCampaignVersionRequest build() {
            return new GetCampaignVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetCampaignVersionRequest> {
        public Builder applicationId(String var1);

        public Builder campaignId(String var1);

        public Builder version(String var1);
    }
}

