/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.EmailChannelRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EmailChannelRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, EmailChannelRequest> {
    private final Boolean enabled;
    private final String fromAddress;
    private final String identity;
    private final String roleArn;

    private EmailChannelRequest(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.fromAddress = builder.fromAddress;
        this.identity = builder.identity;
        this.roleArn = builder.roleArn;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String fromAddress() {
        return this.fromAddress;
    }

    public String identity() {
        return this.identity;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.fromAddress() == null ? 0 : this.fromAddress().hashCode());
        hashCode = 31 * hashCode + (this.identity() == null ? 0 : this.identity().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailChannelRequest)) {
            return false;
        }
        EmailChannelRequest other = (EmailChannelRequest)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.fromAddress() == null ^ this.fromAddress() == null) {
            return false;
        }
        if (other.fromAddress() != null && !other.fromAddress().equals(this.fromAddress())) {
            return false;
        }
        if (other.identity() == null ^ this.identity() == null) {
            return false;
        }
        if (other.identity() != null && !other.identity().equals(this.identity())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        return other.roleArn() == null || other.roleArn().equals(this.roleArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.fromAddress() != null) {
            sb.append("FromAddress: ").append(this.fromAddress()).append(",");
        }
        if (this.identity() != null) {
            sb.append("Identity: ").append(this.identity()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "FromAddress": {
                return Optional.of(clazz.cast(this.fromAddress()));
            }
            case "Identity": {
                return Optional.of(clazz.cast(this.identity()));
            }
            case "RoleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EmailChannelRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String fromAddress;
        private String identity;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailChannelRequest model) {
            this.enabled(model.enabled);
            this.fromAddress(model.fromAddress);
            this.identity(model.identity);
            this.roleArn(model.roleArn);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getFromAddress() {
            return this.fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        public final String getIdentity() {
            return this.identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public EmailChannelRequest build() {
            return new EmailChannelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EmailChannelRequest> {
        public Builder enabled(Boolean var1);

        public Builder fromAddress(String var1);

        public Builder identity(String var1);

        public Builder roleArn(String var1);
    }
}

