/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateSegmentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateSegmentRequest> {
    private final String applicationId;
    private final WriteSegmentRequest writeSegmentRequest;

    private CreateSegmentRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.writeSegmentRequest = builder.writeSegmentRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public WriteSegmentRequest writeSegmentRequest() {
        return this.writeSegmentRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.writeSegmentRequest() == null ? 0 : this.writeSegmentRequest().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSegmentRequest)) {
            return false;
        }
        CreateSegmentRequest other = (CreateSegmentRequest)((Object)obj);
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.writeSegmentRequest() == null ^ this.writeSegmentRequest() == null) {
            return false;
        }
        return other.writeSegmentRequest() == null || other.writeSegmentRequest().equals(this.writeSegmentRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.writeSegmentRequest() != null) {
            sb.append("WriteSegmentRequest: ").append(this.writeSegmentRequest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "WriteSegmentRequest": {
                return Optional.of(clazz.cast(this.writeSegmentRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private WriteSegmentRequest writeSegmentRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSegmentRequest model) {
            this.applicationId(model.applicationId);
            this.writeSegmentRequest(model.writeSegmentRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final WriteSegmentRequest.Builder getWriteSegmentRequest() {
            return this.writeSegmentRequest != null ? this.writeSegmentRequest.toBuilder() : null;
        }

        @Override
        public final Builder writeSegmentRequest(WriteSegmentRequest writeSegmentRequest) {
            this.writeSegmentRequest = writeSegmentRequest;
            return this;
        }

        public final void setWriteSegmentRequest(WriteSegmentRequest.BuilderImpl writeSegmentRequest) {
            this.writeSegmentRequest = writeSegmentRequest != null ? writeSegmentRequest.build() : null;
        }

        public CreateSegmentRequest build() {
            return new CreateSegmentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateSegmentRequest> {
        public Builder applicationId(String var1);

        public Builder writeSegmentRequest(WriteSegmentRequest var1);
    }
}

