/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.ImportJobRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateImportJobRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateImportJobRequest> {
    private final String applicationId;
    private final ImportJobRequest importJobRequest;

    private CreateImportJobRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.importJobRequest = builder.importJobRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public ImportJobRequest importJobRequest() {
        return this.importJobRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.importJobRequest() == null ? 0 : this.importJobRequest().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImportJobRequest)) {
            return false;
        }
        CreateImportJobRequest other = (CreateImportJobRequest)((Object)obj);
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.importJobRequest() == null ^ this.importJobRequest() == null) {
            return false;
        }
        return other.importJobRequest() == null || other.importJobRequest().equals(this.importJobRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.importJobRequest() != null) {
            sb.append("ImportJobRequest: ").append(this.importJobRequest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "ImportJobRequest": {
                return Optional.of(clazz.cast(this.importJobRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private ImportJobRequest importJobRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImportJobRequest model) {
            this.applicationId(model.applicationId);
            this.importJobRequest(model.importJobRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final ImportJobRequest.Builder getImportJobRequest() {
            return this.importJobRequest != null ? this.importJobRequest.toBuilder() : null;
        }

        @Override
        public final Builder importJobRequest(ImportJobRequest importJobRequest) {
            this.importJobRequest = importJobRequest;
            return this;
        }

        public final void setImportJobRequest(ImportJobRequest.BuilderImpl importJobRequest) {
            this.importJobRequest = importJobRequest != null ? importJobRequest.build() : null;
        }

        public CreateImportJobRequest build() {
            return new CreateImportJobRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateImportJobRequest> {
        public Builder applicationId(String var1);

        public Builder importJobRequest(ImportJobRequest var1);
    }
}

