/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.DimensionType;
import software.amazon.awssdk.services.pinpoint.model.ListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.SetDimensionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetDimension
implements StructuredPojo,
ToCopyableBuilder<Builder, SetDimension> {
    private final String dimensionType;
    private final List<String> values;

    private SetDimension(BuilderImpl builder) {
        this.dimensionType = builder.dimensionType;
        this.values = builder.values;
    }

    public String dimensionType() {
        return this.dimensionType;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dimensionType() == null ? 0 : this.dimensionType().hashCode());
        hashCode = 31 * hashCode + (this.values() == null ? 0 : this.values().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDimension)) {
            return false;
        }
        SetDimension other = (SetDimension)obj;
        if (other.dimensionType() == null ^ this.dimensionType() == null) {
            return false;
        }
        if (other.dimensionType() != null && !other.dimensionType().equals(this.dimensionType())) {
            return false;
        }
        if (other.values() == null ^ this.values() == null) {
            return false;
        }
        return other.values() == null || other.values().equals(this.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dimensionType() != null) {
            sb.append("DimensionType: ").append(this.dimensionType()).append(",");
        }
        if (this.values() != null) {
            sb.append("Values: ").append(this.values()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SetDimensionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String dimensionType;
        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(SetDimension model) {
            this.setDimensionType(model.dimensionType);
            this.setValues(model.values);
        }

        public final String getDimensionType() {
            return this.dimensionType;
        }

        @Override
        public final Builder dimensionType(String dimensionType) {
            this.dimensionType = dimensionType;
            return this;
        }

        @Override
        public final Builder dimensionType(DimensionType dimensionType) {
            this.dimensionType(dimensionType.toString());
            return this;
        }

        public final void setDimensionType(String dimensionType) {
            this.dimensionType = dimensionType;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
        }

        public SetDimension build() {
            return new SetDimension(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetDimension> {
        public Builder dimensionType(String var1);

        public Builder dimensionType(DimensionType var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

