/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;

@SdkInternalApi
public class QuietTimeMarshaller {
    private static final MarshallingInfo<String> END_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("End").build();
    private static final MarshallingInfo<String> START_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Start").build();
    private static final QuietTimeMarshaller INSTANCE = new QuietTimeMarshaller();

    public static QuietTimeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(QuietTime quietTime, ProtocolMarshaller protocolMarshaller) {
        if (quietTime == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)quietTime.end(), END_BINDING);
            protocolMarshaller.marshall((Object)quietTime.start(), START_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

