/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;
import software.amazon.awssdk.services.pinpoint.transform.CampaignEmailMessageUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CampaignSmsMessageUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.MessageUnmarshaller;

public class MessageConfigurationUnmarshaller
implements Unmarshaller<MessageConfiguration, JsonUnmarshallerContext> {
    private static final MessageConfigurationUnmarshaller INSTANCE = new MessageConfigurationUnmarshaller();

    public MessageConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        MessageConfiguration.Builder messageConfigurationBuilder = MessageConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("APNSMessage", targetDepth)) {
                    context.nextToken();
                    messageConfigurationBuilder.apnsMessage(MessageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DefaultMessage", targetDepth)) {
                    context.nextToken();
                    messageConfigurationBuilder.defaultMessage(MessageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("EmailMessage", targetDepth)) {
                    context.nextToken();
                    messageConfigurationBuilder.emailMessage(CampaignEmailMessageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("GCMMessage", targetDepth)) {
                    context.nextToken();
                    messageConfigurationBuilder.gcmMessage(MessageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SMSMessage", targetDepth)) {
                    context.nextToken();
                    messageConfigurationBuilder.smsMessage(CampaignSmsMessageUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (MessageConfiguration)messageConfigurationBuilder.build();
    }

    public static MessageConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

