/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.MessageBody;

public class MessageBodyUnmarshaller
implements Unmarshaller<MessageBody, JsonUnmarshallerContext> {
    private static final MessageBodyUnmarshaller INSTANCE = new MessageBodyUnmarshaller();

    public MessageBody unmarshall(JsonUnmarshallerContext context) throws Exception {
        MessageBody.Builder messageBodyBuilder = MessageBody.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Message", targetDepth)) {
                    context.nextToken();
                    messageBodyBuilder.message((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RequestID", targetDepth)) {
                    context.nextToken();
                    messageBodyBuilder.requestID((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (MessageBody)messageBodyBuilder.build();
    }

    public static MessageBodyUnmarshaller getInstance() {
        return INSTANCE;
    }
}

