/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage;

@SdkInternalApi
public class DefaultPushNotificationMessageMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").build();
    private static final MarshallingInfo<Map> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").build();
    private static final MarshallingInfo<Boolean> SILENTPUSH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SilentPush").build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").build();
    private static final DefaultPushNotificationMessageMarshaller INSTANCE = new DefaultPushNotificationMessageMarshaller();

    public static DefaultPushNotificationMessageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DefaultPushNotificationMessage defaultPushNotificationMessage, ProtocolMarshaller protocolMarshaller) {
        if (defaultPushNotificationMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)defaultPushNotificationMessage.action(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)defaultPushNotificationMessage.body(), BODY_BINDING);
            protocolMarshaller.marshall(defaultPushNotificationMessage.data(), DATA_BINDING);
            protocolMarshaller.marshall((Object)defaultPushNotificationMessage.silentPush(), SILENTPUSH_BINDING);
            protocolMarshaller.marshall(defaultPushNotificationMessage.substitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall((Object)defaultPushNotificationMessage.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)defaultPushNotificationMessage.url(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

