/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.RecencyDimension;

@SdkInternalApi
public class RecencyDimensionMarshaller {
    private static final MarshallingInfo<String> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").build();
    private static final MarshallingInfo<String> RECENCYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecencyType").build();
    private static final RecencyDimensionMarshaller instance = new RecencyDimensionMarshaller();

    public static RecencyDimensionMarshaller getInstance() {
        return instance;
    }

    public void marshall(RecencyDimension recencyDimension, ProtocolMarshaller protocolMarshaller) {
        if (recencyDimension == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recencyDimension.duration(), DURATION_BINDING);
            protocolMarshaller.marshall((Object)recencyDimension.recencyType(), RECENCYTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

