/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.ActivityResponse;

@SdkInternalApi
public class ActivityResponseMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").build();
    private static final MarshallingInfo<String> CAMPAIGNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CampaignId").build();
    private static final MarshallingInfo<String> END_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("End").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> RESULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Result").build();
    private static final MarshallingInfo<String> SCHEDULEDSTART_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScheduledStart").build();
    private static final MarshallingInfo<String> START_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Start").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<Integer> SUCCESSFULENDPOINTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SuccessfulEndpointCount").build();
    private static final MarshallingInfo<Integer> TIMEZONESCOMPLETEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimezonesCompletedCount").build();
    private static final MarshallingInfo<Integer> TIMEZONESTOTALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimezonesTotalCount").build();
    private static final MarshallingInfo<Integer> TOTALENDPOINTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalEndpointCount").build();
    private static final MarshallingInfo<String> TREATMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TreatmentId").build();
    private static final ActivityResponseMarshaller instance = new ActivityResponseMarshaller();

    public static ActivityResponseMarshaller getInstance() {
        return instance;
    }

    public void marshall(ActivityResponse activityResponse, ProtocolMarshaller protocolMarshaller) {
        if (activityResponse == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)activityResponse.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.campaignId(), CAMPAIGNID_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.end(), END_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.result(), RESULT_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.scheduledStart(), SCHEDULEDSTART_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.start(), START_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.successfulEndpointCount(), SUCCESSFULENDPOINTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.timezonesCompletedCount(), TIMEZONESCOMPLETEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.timezonesTotalCount(), TIMEZONESTOTALCOUNT_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.totalEndpointCount(), TOTALENDPOINTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.treatmentId(), TREATMENTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

