/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.MessageType;
import software.amazon.awssdk.services.pinpoint.transform.CampaignSmsMessageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CampaignSmsMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, CampaignSmsMessage> {
    private final String body;
    private final String messageType;
    private final String senderId;

    private CampaignSmsMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.messageType = builder.messageType;
        this.senderId = builder.senderId;
    }

    public String body() {
        return this.body;
    }

    public String messageType() {
        return this.messageType;
    }

    public String senderId() {
        return this.senderId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.body() == null ? 0 : this.body().hashCode());
        hashCode = 31 * hashCode + (this.messageType() == null ? 0 : this.messageType().hashCode());
        hashCode = 31 * hashCode + (this.senderId() == null ? 0 : this.senderId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignSmsMessage)) {
            return false;
        }
        CampaignSmsMessage other = (CampaignSmsMessage)obj;
        if (other.body() == null ^ this.body() == null) {
            return false;
        }
        if (other.body() != null && !other.body().equals(this.body())) {
            return false;
        }
        if (other.messageType() == null ^ this.messageType() == null) {
            return false;
        }
        if (other.messageType() != null && !other.messageType().equals(this.messageType())) {
            return false;
        }
        if (other.senderId() == null ^ this.senderId() == null) {
            return false;
        }
        return other.senderId() == null || other.senderId().equals(this.senderId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (this.messageType() != null) {
            sb.append("MessageType: ").append(this.messageType()).append(",");
        }
        if (this.senderId() != null) {
            sb.append("SenderId: ").append(this.senderId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CampaignSmsMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String body;
        private String messageType;
        private String senderId;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignSmsMessage model) {
            this.setBody(model.body);
            this.setMessageType(model.messageType);
            this.setSenderId(model.senderId);
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final void setMessageType(MessageType messageType) {
            this.messageType(messageType.toString());
        }

        public final String getSenderId() {
            return this.senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public CampaignSmsMessage build() {
            return new CampaignSmsMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CampaignSmsMessage> {
        public Builder body(String var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder senderId(String var1);
    }
}

