/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;
import software.amazon.awssdk.services.pinpoint.transform.ApplicationSettingsResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationSettingsResource
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationSettingsResource> {
    private final String applicationId;
    private final String lastModifiedDate;
    private final CampaignLimits limits;
    private final QuietTime quietTime;

    private ApplicationSettingsResource(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.limits = builder.limits;
        this.quietTime = builder.quietTime;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public CampaignLimits limits() {
        return this.limits;
    }

    public QuietTime quietTime() {
        return this.quietTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedDate() == null ? 0 : this.lastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.limits() == null ? 0 : this.limits().hashCode());
        hashCode = 31 * hashCode + (this.quietTime() == null ? 0 : this.quietTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettingsResource)) {
            return false;
        }
        ApplicationSettingsResource other = (ApplicationSettingsResource)obj;
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        if (other.lastModifiedDate() != null && !other.lastModifiedDate().equals(this.lastModifiedDate())) {
            return false;
        }
        if (other.limits() == null ^ this.limits() == null) {
            return false;
        }
        if (other.limits() != null && !other.limits().equals(this.limits())) {
            return false;
        }
        if (other.quietTime() == null ^ this.quietTime() == null) {
            return false;
        }
        return other.quietTime() == null || other.quietTime().equals(this.quietTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (this.limits() != null) {
            sb.append("Limits: ").append(this.limits()).append(",");
        }
        if (this.quietTime() != null) {
            sb.append("QuietTime: ").append(this.quietTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationSettingsResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String lastModifiedDate;
        private CampaignLimits limits;
        private QuietTime quietTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettingsResource model) {
            this.setApplicationId(model.applicationId);
            this.setLastModifiedDate(model.lastModifiedDate);
            this.setLimits(model.limits);
            this.setQuietTime(model.quietTime);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final CampaignLimits getLimits() {
            return this.limits;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits limits) {
            this.limits = limits;
        }

        public final QuietTime getQuietTime() {
            return this.quietTime;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
        }

        public ApplicationSettingsResource build() {
            return new ApplicationSettingsResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationSettingsResource> {
        public Builder applicationId(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder limits(CampaignLimits var1);

        public Builder quietTime(QuietTime var1);
    }
}

