/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessageRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SendUsersMessageRequestMarshaller {
    private static final MarshallingInfo<Map> CONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Context").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MESSAGECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageConfiguration").isBinary(false).build();
    private static final MarshallingInfo<String> TRACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TraceId").isBinary(false).build();
    private static final MarshallingInfo<Map> USERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Users").isBinary(false).build();
    private static final SendUsersMessageRequestMarshaller INSTANCE = new SendUsersMessageRequestMarshaller();

    private SendUsersMessageRequestMarshaller() {
    }

    public static SendUsersMessageRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SendUsersMessageRequest sendUsersMessageRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sendUsersMessageRequest, (String)"sendUsersMessageRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(sendUsersMessageRequest.context(), CONTEXT_BINDING);
            protocolMarshaller.marshall((Object)sendUsersMessageRequest.messageConfiguration(), MESSAGECONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)sendUsersMessageRequest.traceId(), TRACEID_BINDING);
            protocolMarshaller.marshall(sendUsersMessageRequest.users(), USERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

