/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.SegmentReference;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SegmentReferenceMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<Integer> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final SegmentReferenceMarshaller INSTANCE = new SegmentReferenceMarshaller();

    private SegmentReferenceMarshaller() {
    }

    public static SegmentReferenceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SegmentReference segmentReference, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)segmentReference, (String)"segmentReference");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)segmentReference.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)segmentReference.version(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

