/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.SegmentGroup;
import software.amazon.awssdk.services.pinpoint.transform.SegmentDimensionsUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SegmentReferenceUnmarshaller;

public class SegmentGroupUnmarshaller
implements Unmarshaller<SegmentGroup, JsonUnmarshallerContext> {
    private static final SegmentGroupUnmarshaller INSTANCE = new SegmentGroupUnmarshaller();

    public SegmentGroup unmarshall(JsonUnmarshallerContext context) throws Exception {
        SegmentGroup.Builder segmentGroupBuilder = SegmentGroup.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Dimensions", targetDepth)) {
                    context.nextToken();
                    segmentGroupBuilder.dimensions(new ListUnmarshaller((Unmarshaller)SegmentDimensionsUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("SourceSegments", targetDepth)) {
                    context.nextToken();
                    segmentGroupBuilder.sourceSegments(new ListUnmarshaller((Unmarshaller)SegmentReferenceUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("SourceType", targetDepth)) {
                    context.nextToken();
                    segmentGroupBuilder.sourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    segmentGroupBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SegmentGroup)segmentGroupBuilder.build();
    }

    public static SegmentGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

