/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.SegmentGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SegmentGroupMarshaller {
    private static final MarshallingInfo<List> DIMENSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimensions").isBinary(false).build();
    private static final MarshallingInfo<List> SOURCESEGMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceSegments").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceType").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final SegmentGroupMarshaller INSTANCE = new SegmentGroupMarshaller();

    private SegmentGroupMarshaller() {
    }

    public static SegmentGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SegmentGroup segmentGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)segmentGroup, (String)"segmentGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(segmentGroup.dimensions(), DIMENSIONS_BINDING);
            protocolMarshaller.marshall(segmentGroup.sourceSegments(), SOURCESEGMENTS_BINDING);
            protocolMarshaller.marshall((Object)segmentGroup.sourceTypeAsString(), SOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)segmentGroup.typeAsString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

