/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.SegmentGroupList;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SegmentGroupListMarshaller {
    private static final MarshallingInfo<List> GROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Groups").isBinary(false).build();
    private static final MarshallingInfo<String> INCLUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Include").isBinary(false).build();
    private static final SegmentGroupListMarshaller INSTANCE = new SegmentGroupListMarshaller();

    private SegmentGroupListMarshaller() {
    }

    public static SegmentGroupListMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SegmentGroupList segmentGroupList, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)segmentGroupList, (String)"segmentGroupList");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(segmentGroupList.groups(), GROUPS_BINDING);
            protocolMarshaller.marshall((Object)segmentGroupList.includeAsString(), INCLUDE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

