/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.NumberValidateRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NumberValidateRequestMarshaller {
    private static final MarshallingInfo<String> ISOCOUNTRYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsoCountryCode").isBinary(false).build();
    private static final MarshallingInfo<String> PHONENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhoneNumber").isBinary(false).build();
    private static final NumberValidateRequestMarshaller INSTANCE = new NumberValidateRequestMarshaller();

    private NumberValidateRequestMarshaller() {
    }

    public static NumberValidateRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NumberValidateRequest numberValidateRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)numberValidateRequest, (String)"numberValidateRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)numberValidateRequest.isoCountryCode(), ISOCOUNTRYCODE_BINDING);
            protocolMarshaller.marshall((Object)numberValidateRequest.phoneNumber(), PHONENUMBER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

