/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.ItemResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ItemResponseMarshaller {
    private static final MarshallingInfo<StructuredPojo> ENDPOINTITEMRESPONSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointItemResponse").isBinary(false).build();
    private static final MarshallingInfo<Map> EVENTSITEMRESPONSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventsItemResponse").isBinary(false).build();
    private static final ItemResponseMarshaller INSTANCE = new ItemResponseMarshaller();

    private ItemResponseMarshaller() {
    }

    public static ItemResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ItemResponse itemResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)itemResponse, (String)"itemResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)itemResponse.endpointItemResponse(), ENDPOINTITEMRESPONSE_BINDING);
            protocolMarshaller.marshall(itemResponse.eventsItemResponse(), EVENTSITEMRESPONSE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

