/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.GPSPointDimension;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GPSPointDimensionMarshaller {
    private static final MarshallingInfo<StructuredPojo> COORDINATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Coordinates").isBinary(false).build();
    private static final MarshallingInfo<Double> RANGEINKILOMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RangeInKilometers").isBinary(false).build();
    private static final GPSPointDimensionMarshaller INSTANCE = new GPSPointDimensionMarshaller();

    private GPSPointDimensionMarshaller() {
    }

    public static GPSPointDimensionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GPSPointDimension gpsPointDimension, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)gpsPointDimension, (String)"gpsPointDimension");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)gpsPointDimension.coordinates(), COORDINATES_BINDING);
            protocolMarshaller.marshall((Object)gpsPointDimension.rangeInKilometers(), RANGEINKILOMETERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

