/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.GPSCoordinates;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GPSCoordinatesMarshaller {
    private static final MarshallingInfo<Double> LATITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Latitude").isBinary(false).build();
    private static final MarshallingInfo<Double> LONGITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Longitude").isBinary(false).build();
    private static final GPSCoordinatesMarshaller INSTANCE = new GPSCoordinatesMarshaller();

    private GPSCoordinatesMarshaller() {
    }

    public static GPSCoordinatesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GPSCoordinates gpsCoordinates, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)gpsCoordinates, (String)"gpsCoordinates");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)gpsCoordinates.latitude(), LATITUDE_BINDING);
            protocolMarshaller.marshall((Object)gpsCoordinates.longitude(), LONGITUDE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

