/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.ExportJobRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExportJobRequestMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> S3URLPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3UrlPrefix").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentId").isBinary(false).build();
    private static final MarshallingInfo<Integer> SEGMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentVersion").isBinary(false).build();
    private static final ExportJobRequestMarshaller INSTANCE = new ExportJobRequestMarshaller();

    private ExportJobRequestMarshaller() {
    }

    public static ExportJobRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExportJobRequest exportJobRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)exportJobRequest, (String)"exportJobRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)exportJobRequest.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)exportJobRequest.s3UrlPrefix(), S3URLPREFIX_BINDING);
            protocolMarshaller.marshall((Object)exportJobRequest.segmentId(), SEGMENTID_BINDING);
            protocolMarshaller.marshall((Object)exportJobRequest.segmentVersion(), SEGMENTVERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

