/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.EventsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventsRequestMarshaller {
    private static final MarshallingInfo<Map> BATCHITEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchItem").isBinary(false).build();
    private static final EventsRequestMarshaller INSTANCE = new EventsRequestMarshaller();

    private EventsRequestMarshaller() {
    }

    public static EventsRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventsRequest eventsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventsRequest, (String)"eventsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(eventsRequest.batchItem(), BATCHITEM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

