/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.EventsBatch;
import software.amazon.awssdk.services.pinpoint.transform.EventUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PublicEndpointUnmarshaller;

public class EventsBatchUnmarshaller
implements Unmarshaller<EventsBatch, JsonUnmarshallerContext> {
    private static final EventsBatchUnmarshaller INSTANCE = new EventsBatchUnmarshaller();

    public EventsBatch unmarshall(JsonUnmarshallerContext context) throws Exception {
        EventsBatch.Builder eventsBatchBuilder = EventsBatch.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Endpoint", targetDepth)) {
                    context.nextToken();
                    eventsBatchBuilder.endpoint(PublicEndpointUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Events", targetDepth)) {
                    context.nextToken();
                    eventsBatchBuilder.events(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)EventUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EventsBatch)eventsBatchBuilder.build();
    }

    public static EventsBatchUnmarshaller getInstance() {
        return INSTANCE;
    }
}

