/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.Event;
import software.amazon.awssdk.services.pinpoint.transform.SessionUnmarshaller;

public class EventUnmarshaller
implements Unmarshaller<Event, JsonUnmarshallerContext> {
    private static final EventUnmarshaller INSTANCE = new EventUnmarshaller();

    public Event unmarshall(JsonUnmarshallerContext context) throws Exception {
        Event.Builder eventBuilder = Event.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    eventBuilder.attributes(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ClientSdkVersion", targetDepth)) {
                    context.nextToken();
                    eventBuilder.clientSdkVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EventType", targetDepth)) {
                    context.nextToken();
                    eventBuilder.eventType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Metrics", targetDepth)) {
                    context.nextToken();
                    eventBuilder.metrics(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(Double.class)).unmarshall(context));
                }
                if (context.testExpression("Session", targetDepth)) {
                    context.nextToken();
                    eventBuilder.session(SessionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Timestamp", targetDepth)) {
                    context.nextToken();
                    eventBuilder.timestamp((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Event)eventBuilder.build();
    }

    public static EventUnmarshaller getInstance() {
        return INSTANCE;
    }
}

