/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.EventItemResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventItemResponseMarshaller {
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final MarshallingInfo<Integer> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusCode").isBinary(false).build();
    private static final EventItemResponseMarshaller INSTANCE = new EventItemResponseMarshaller();

    private EventItemResponseMarshaller() {
    }

    public static EventItemResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventItemResponse eventItemResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventItemResponse, (String)"eventItemResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)eventItemResponse.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)eventItemResponse.statusCode(), STATUSCODE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

