/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.EndpointsResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EndpointsResponseMarshaller {
    private static final MarshallingInfo<List> ITEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Item").isBinary(false).build();
    private static final EndpointsResponseMarshaller INSTANCE = new EndpointsResponseMarshaller();

    private EndpointsResponseMarshaller() {
    }

    public static EndpointsResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EndpointsResponse endpointsResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)endpointsResponse, (String)"endpointsResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(endpointsResponse.item(), ITEM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

