/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateExportJobRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("application-id").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXPORTJOBREQUEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(false).build();
    private static final CreateExportJobRequestModelMarshaller INSTANCE = new CreateExportJobRequestModelMarshaller();

    private CreateExportJobRequestModelMarshaller() {
    }

    public static CreateExportJobRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateExportJobRequest createExportJobRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createExportJobRequest), (String)"createExportJobRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createExportJobRequest.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)createExportJobRequest.exportJobRequest(), EXPORTJOBREQUEST_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

