/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.CampaignsResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CampaignsResponseMarshaller {
    private static final MarshallingInfo<List> ITEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Item").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final CampaignsResponseMarshaller INSTANCE = new CampaignsResponseMarshaller();

    private CampaignsResponseMarshaller() {
    }

    public static CampaignsResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CampaignsResponse campaignsResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)campaignsResponse, (String)"campaignsResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(campaignsResponse.item(), ITEM_BINDING);
            protocolMarshaller.marshall((Object)campaignsResponse.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

