/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.CampaignHook;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CampaignHookMarshaller {
    private static final MarshallingInfo<String> LAMBDAFUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LambdaFunctionName").isBinary(false).build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mode").isBinary(false).build();
    private static final MarshallingInfo<String> WEBURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WebUrl").isBinary(false).build();
    private static final CampaignHookMarshaller INSTANCE = new CampaignHookMarshaller();

    private CampaignHookMarshaller() {
    }

    public static CampaignHookMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CampaignHook campaignHook, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)campaignHook, (String)"campaignHook");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)campaignHook.lambdaFunctionName(), LAMBDAFUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)campaignHook.modeAsString(), MODE_BINDING);
            protocolMarshaller.marshall((Object)campaignHook.webUrl(), WEBURL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

