/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.AttributesResource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttributesResourceMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").isBinary(false).build();
    private static final MarshallingInfo<String> ATTRIBUTETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeType").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final AttributesResourceMarshaller INSTANCE = new AttributesResourceMarshaller();

    private AttributesResourceMarshaller() {
    }

    public static AttributesResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttributesResource attributesResource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)attributesResource, (String)"attributesResource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attributesResource.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)attributesResource.attributeType(), ATTRIBUTETYPE_BINDING);
            protocolMarshaller.marshall(attributesResource.attributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

