/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CampaignHook;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;
import software.amazon.awssdk.services.pinpoint.transform.WriteApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteApplicationSettingsRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, WriteApplicationSettingsRequest> {
    private final CampaignHook campaignHook;
    private final Boolean cloudWatchMetricsEnabled;
    private final CampaignLimits limits;
    private final QuietTime quietTime;

    private WriteApplicationSettingsRequest(BuilderImpl builder) {
        this.campaignHook = builder.campaignHook;
        this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
        this.limits = builder.limits;
        this.quietTime = builder.quietTime;
    }

    public CampaignHook campaignHook() {
        return this.campaignHook;
    }

    public Boolean cloudWatchMetricsEnabled() {
        return this.cloudWatchMetricsEnabled;
    }

    public CampaignLimits limits() {
        return this.limits;
    }

    public QuietTime quietTime() {
        return this.quietTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        hashCode = 31 * hashCode + Objects.hashCode(this.quietTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteApplicationSettingsRequest)) {
            return false;
        }
        WriteApplicationSettingsRequest other = (WriteApplicationSettingsRequest)obj;
        return Objects.equals(this.campaignHook(), other.campaignHook()) && Objects.equals(this.cloudWatchMetricsEnabled(), other.cloudWatchMetricsEnabled()) && Objects.equals(this.limits(), other.limits()) && Objects.equals(this.quietTime(), other.quietTime());
    }

    public String toString() {
        return ToString.builder((String)"WriteApplicationSettingsRequest").add("CampaignHook", (Object)this.campaignHook()).add("CloudWatchMetricsEnabled", (Object)this.cloudWatchMetricsEnabled()).add("Limits", (Object)this.limits()).add("QuietTime", (Object)this.quietTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CampaignHook": {
                return Optional.ofNullable(clazz.cast(this.campaignHook()));
            }
            case "CloudWatchMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchMetricsEnabled()));
            }
            case "Limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
            case "QuietTime": {
                return Optional.ofNullable(clazz.cast(this.quietTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteApplicationSettingsRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private CampaignHook campaignHook;
        private Boolean cloudWatchMetricsEnabled;
        private CampaignLimits limits;
        private QuietTime quietTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteApplicationSettingsRequest model) {
            this.campaignHook(model.campaignHook);
            this.cloudWatchMetricsEnabled(model.cloudWatchMetricsEnabled);
            this.limits(model.limits);
            this.quietTime(model.quietTime);
        }

        public final CampaignHook.Builder getCampaignHook() {
            return this.campaignHook != null ? this.campaignHook.toBuilder() : null;
        }

        @Override
        public final Builder campaignHook(CampaignHook campaignHook) {
            this.campaignHook = campaignHook;
            return this;
        }

        public final void setCampaignHook(CampaignHook.BuilderImpl campaignHook) {
            this.campaignHook = campaignHook != null ? campaignHook.build() : null;
        }

        public final Boolean getCloudWatchMetricsEnabled() {
            return this.cloudWatchMetricsEnabled;
        }

        @Override
        public final Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        public final void setCloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
        }

        public final CampaignLimits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final QuietTime.Builder getQuietTime() {
            return this.quietTime != null ? this.quietTime.toBuilder() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        public WriteApplicationSettingsRequest build() {
            return new WriteApplicationSettingsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WriteApplicationSettingsRequest> {
        public Builder campaignHook(CampaignHook var1);

        default public Builder campaignHook(Consumer<CampaignHook.Builder> campaignHook) {
            return this.campaignHook((CampaignHook)((CampaignHook.Builder)CampaignHook.builder().applyMutation(campaignHook)).build());
        }

        public Builder cloudWatchMetricsEnabled(Boolean var1);

        public Builder limits(CampaignLimits var1);

        default public Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return this.limits((CampaignLimits)((CampaignLimits.Builder)CampaignLimits.builder().applyMutation(limits)).build());
        }

        public Builder quietTime(QuietTime var1);

        default public Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return this.quietTime((QuietTime)((QuietTime.Builder)QuietTime.builder().applyMutation(quietTime)).build());
        }
    }
}

