/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ListOfSegmentResponseCopier;
import software.amazon.awssdk.services.pinpoint.model.SegmentResponse;
import software.amazon.awssdk.services.pinpoint.transform.SegmentsResponseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentsResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, SegmentsResponse> {
    private final List<SegmentResponse> item;
    private final String nextToken;

    private SegmentsResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.nextToken = builder.nextToken;
    }

    public List<SegmentResponse> item() {
        return this.item;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentsResponse)) {
            return false;
        }
        SegmentsResponse other = (SegmentsResponse)obj;
        return Objects.equals(this.item(), other.item()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"SegmentsResponse").add("Item", this.item()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentsResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SegmentResponse> item = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentsResponse model) {
            this.item(model.item);
            this.nextToken(model.nextToken);
        }

        public final Collection<SegmentResponse.Builder> getItem() {
            return this.item != null ? (Collection)this.item.stream().map(SegmentResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<SegmentResponse> item) {
            this.item = ListOfSegmentResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(SegmentResponse ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<SegmentResponse.Builder> ... item) {
            this.item(Stream.of(item).map(c -> (SegmentResponse)((SegmentResponse.Builder)SegmentResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<SegmentResponse.BuilderImpl> item) {
            this.item = ListOfSegmentResponseCopier.copyFromBuilder(item);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public SegmentsResponse build() {
            return new SegmentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SegmentsResponse> {
        public Builder item(Collection<SegmentResponse> var1);

        public Builder item(SegmentResponse ... var1);

        public Builder item(Consumer<SegmentResponse.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

