/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.GPSPointDimension;
import software.amazon.awssdk.services.pinpoint.model.SetDimension;
import software.amazon.awssdk.services.pinpoint.transform.SegmentLocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, SegmentLocation> {
    private final SetDimension country;
    private final GPSPointDimension gpsPoint;

    private SegmentLocation(BuilderImpl builder) {
        this.country = builder.country;
        this.gpsPoint = builder.gpsPoint;
    }

    public SetDimension country() {
        return this.country;
    }

    public GPSPointDimension gpsPoint() {
        return this.gpsPoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.gpsPoint());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentLocation)) {
            return false;
        }
        SegmentLocation other = (SegmentLocation)obj;
        return Objects.equals(this.country(), other.country()) && Objects.equals(this.gpsPoint(), other.gpsPoint());
    }

    public String toString() {
        return ToString.builder((String)"SegmentLocation").add("Country", (Object)this.country()).add("GPSPoint", (Object)this.gpsPoint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "GPSPoint": {
                return Optional.ofNullable(clazz.cast(this.gpsPoint()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private SetDimension country;
        private GPSPointDimension gpsPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentLocation model) {
            this.country(model.country);
            this.gpsPoint(model.gpsPoint);
        }

        public final SetDimension.Builder getCountry() {
            return this.country != null ? this.country.toBuilder() : null;
        }

        @Override
        public final Builder country(SetDimension country) {
            this.country = country;
            return this;
        }

        public final void setCountry(SetDimension.BuilderImpl country) {
            this.country = country != null ? country.build() : null;
        }

        public final GPSPointDimension.Builder getGPSPoint() {
            return this.gpsPoint != null ? this.gpsPoint.toBuilder() : null;
        }

        @Override
        public final Builder gpsPoint(GPSPointDimension gpsPoint) {
            this.gpsPoint = gpsPoint;
            return this;
        }

        public final void setGPSPoint(GPSPointDimension.BuilderImpl gpsPoint) {
            this.gpsPoint = gpsPoint != null ? gpsPoint.build() : null;
        }

        public SegmentLocation build() {
            return new SegmentLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SegmentLocation> {
        public Builder country(SetDimension var1);

        default public Builder country(Consumer<SetDimension.Builder> country) {
            return this.country((SetDimension)((SetDimension.Builder)SetDimension.builder().applyMutation(country)).build());
        }

        public Builder gpsPoint(GPSPointDimension var1);

        default public Builder gpsPoint(Consumer<GPSPointDimension.Builder> gpsPoint) {
            return this.gpsPoint((GPSPointDimension)((GPSPointDimension.Builder)GPSPointDimension.builder().applyMutation(gpsPoint)).build());
        }
    }
}

