/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.EndpointItemResponse;
import software.amazon.awssdk.services.pinpoint.model.EventItemResponse;
import software.amazon.awssdk.services.pinpoint.model.MapOfEventItemResponseCopier;
import software.amazon.awssdk.services.pinpoint.transform.ItemResponseMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ItemResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, ItemResponse> {
    private final EndpointItemResponse endpointItemResponse;
    private final Map<String, EventItemResponse> eventsItemResponse;

    private ItemResponse(BuilderImpl builder) {
        this.endpointItemResponse = builder.endpointItemResponse;
        this.eventsItemResponse = builder.eventsItemResponse;
    }

    public EndpointItemResponse endpointItemResponse() {
        return this.endpointItemResponse;
    }

    public Map<String, EventItemResponse> eventsItemResponse() {
        return this.eventsItemResponse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointItemResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsItemResponse());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemResponse)) {
            return false;
        }
        ItemResponse other = (ItemResponse)obj;
        return Objects.equals(this.endpointItemResponse(), other.endpointItemResponse()) && Objects.equals(this.eventsItemResponse(), other.eventsItemResponse());
    }

    public String toString() {
        return ToString.builder((String)"ItemResponse").add("EndpointItemResponse", (Object)this.endpointItemResponse()).add("EventsItemResponse", this.eventsItemResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointItemResponse": {
                return Optional.ofNullable(clazz.cast(this.endpointItemResponse()));
            }
            case "EventsItemResponse": {
                return Optional.ofNullable(clazz.cast(this.eventsItemResponse()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ItemResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private EndpointItemResponse endpointItemResponse;
        private Map<String, EventItemResponse> eventsItemResponse = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ItemResponse model) {
            this.endpointItemResponse(model.endpointItemResponse);
            this.eventsItemResponse(model.eventsItemResponse);
        }

        public final EndpointItemResponse.Builder getEndpointItemResponse() {
            return this.endpointItemResponse != null ? this.endpointItemResponse.toBuilder() : null;
        }

        @Override
        public final Builder endpointItemResponse(EndpointItemResponse endpointItemResponse) {
            this.endpointItemResponse = endpointItemResponse;
            return this;
        }

        public final void setEndpointItemResponse(EndpointItemResponse.BuilderImpl endpointItemResponse) {
            this.endpointItemResponse = endpointItemResponse != null ? endpointItemResponse.build() : null;
        }

        public final Map<String, EventItemResponse.Builder> getEventsItemResponse() {
            return this.eventsItemResponse != null ? CollectionUtils.mapValues(this.eventsItemResponse, EventItemResponse::toBuilder) : null;
        }

        @Override
        public final Builder eventsItemResponse(Map<String, EventItemResponse> eventsItemResponse) {
            this.eventsItemResponse = MapOfEventItemResponseCopier.copy(eventsItemResponse);
            return this;
        }

        public final void setEventsItemResponse(Map<String, EventItemResponse.BuilderImpl> eventsItemResponse) {
            this.eventsItemResponse = MapOfEventItemResponseCopier.copyFromBuilder(eventsItemResponse);
        }

        public ItemResponse build() {
            return new ItemResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ItemResponse> {
        public Builder endpointItemResponse(EndpointItemResponse var1);

        default public Builder endpointItemResponse(Consumer<EndpointItemResponse.Builder> endpointItemResponse) {
            return this.endpointItemResponse((EndpointItemResponse)((EndpointItemResponse.Builder)EndpointItemResponse.builder().applyMutation(endpointItemResponse)).build());
        }

        public Builder eventsItemResponse(Map<String, EventItemResponse> var1);
    }
}

