/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.GPSCoordinates;
import software.amazon.awssdk.services.pinpoint.transform.GPSPointDimensionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GPSPointDimension
implements StructuredPojo,
ToCopyableBuilder<Builder, GPSPointDimension> {
    private final GPSCoordinates coordinates;
    private final Double rangeInKilometers;

    private GPSPointDimension(BuilderImpl builder) {
        this.coordinates = builder.coordinates;
        this.rangeInKilometers = builder.rangeInKilometers;
    }

    public GPSCoordinates coordinates() {
        return this.coordinates;
    }

    public Double rangeInKilometers() {
        return this.rangeInKilometers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coordinates());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeInKilometers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GPSPointDimension)) {
            return false;
        }
        GPSPointDimension other = (GPSPointDimension)obj;
        return Objects.equals(this.coordinates(), other.coordinates()) && Objects.equals(this.rangeInKilometers(), other.rangeInKilometers());
    }

    public String toString() {
        return ToString.builder((String)"GPSPointDimension").add("Coordinates", (Object)this.coordinates()).add("RangeInKilometers", (Object)this.rangeInKilometers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Coordinates": {
                return Optional.ofNullable(clazz.cast(this.coordinates()));
            }
            case "RangeInKilometers": {
                return Optional.ofNullable(clazz.cast(this.rangeInKilometers()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GPSPointDimensionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private GPSCoordinates coordinates;
        private Double rangeInKilometers;

        private BuilderImpl() {
        }

        private BuilderImpl(GPSPointDimension model) {
            this.coordinates(model.coordinates);
            this.rangeInKilometers(model.rangeInKilometers);
        }

        public final GPSCoordinates.Builder getCoordinates() {
            return this.coordinates != null ? this.coordinates.toBuilder() : null;
        }

        @Override
        public final Builder coordinates(GPSCoordinates coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public final void setCoordinates(GPSCoordinates.BuilderImpl coordinates) {
            this.coordinates = coordinates != null ? coordinates.build() : null;
        }

        public final Double getRangeInKilometers() {
            return this.rangeInKilometers;
        }

        @Override
        public final Builder rangeInKilometers(Double rangeInKilometers) {
            this.rangeInKilometers = rangeInKilometers;
            return this;
        }

        public final void setRangeInKilometers(Double rangeInKilometers) {
            this.rangeInKilometers = rangeInKilometers;
        }

        public GPSPointDimension build() {
            return new GPSPointDimension(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GPSPointDimension> {
        public Builder coordinates(GPSCoordinates var1);

        default public Builder coordinates(Consumer<GPSCoordinates.Builder> coordinates) {
            return this.coordinates((GPSCoordinates)((GPSCoordinates.Builder)GPSCoordinates.builder().applyMutation(coordinates)).build());
        }

        public Builder rangeInKilometers(Double var1);
    }
}

