/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.ExportJobResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportJobResource
implements StructuredPojo,
ToCopyableBuilder<Builder, ExportJobResource> {
    private final String roleArn;
    private final String s3UrlPrefix;
    private final String segmentId;
    private final Integer segmentVersion;

    private ExportJobResource(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.s3UrlPrefix = builder.s3UrlPrefix;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String s3UrlPrefix() {
        return this.s3UrlPrefix;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public Integer segmentVersion() {
        return this.segmentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3UrlPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJobResource)) {
            return false;
        }
        ExportJobResource other = (ExportJobResource)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.s3UrlPrefix(), other.s3UrlPrefix()) && Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.segmentVersion(), other.segmentVersion());
    }

    public String toString() {
        return ToString.builder((String)"ExportJobResource").add("RoleArn", (Object)this.roleArn()).add("S3UrlPrefix", (Object)this.s3UrlPrefix()).add("SegmentId", (Object)this.segmentId()).add("SegmentVersion", (Object)this.segmentVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "S3UrlPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3UrlPrefix()));
            }
            case "SegmentId": {
                return Optional.ofNullable(clazz.cast(this.segmentId()));
            }
            case "SegmentVersion": {
                return Optional.ofNullable(clazz.cast(this.segmentVersion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExportJobResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String s3UrlPrefix;
        private String segmentId;
        private Integer segmentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJobResource model) {
            this.roleArn(model.roleArn);
            this.s3UrlPrefix(model.s3UrlPrefix);
            this.segmentId(model.segmentId);
            this.segmentVersion(model.segmentVersion);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getS3UrlPrefix() {
            return this.s3UrlPrefix;
        }

        @Override
        public final Builder s3UrlPrefix(String s3UrlPrefix) {
            this.s3UrlPrefix = s3UrlPrefix;
            return this;
        }

        public final void setS3UrlPrefix(String s3UrlPrefix) {
            this.s3UrlPrefix = s3UrlPrefix;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final Integer getSegmentVersion() {
            return this.segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        public ExportJobResource build() {
            return new ExportJobResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExportJobResource> {
        public Builder roleArn(String var1);

        public Builder s3UrlPrefix(String var1);

        public Builder segmentId(String var1);

        public Builder segmentVersion(Integer var1);
    }
}

