/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.Event;
import software.amazon.awssdk.services.pinpoint.model.MapOfEventCopier;
import software.amazon.awssdk.services.pinpoint.model.PublicEndpoint;
import software.amazon.awssdk.services.pinpoint.transform.EventsBatchMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventsBatch
implements StructuredPojo,
ToCopyableBuilder<Builder, EventsBatch> {
    private final PublicEndpoint endpoint;
    private final Map<String, Event> events;

    private EventsBatch(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.events = builder.events;
    }

    public PublicEndpoint endpoint() {
        return this.endpoint;
    }

    public Map<String, Event> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsBatch)) {
            return false;
        }
        EventsBatch other = (EventsBatch)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.events(), other.events());
    }

    public String toString() {
        return ToString.builder((String)"EventsBatch").add("Endpoint", (Object)this.endpoint()).add("Events", this.events()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventsBatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private PublicEndpoint endpoint;
        private Map<String, Event> events = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsBatch model) {
            this.endpoint(model.endpoint);
            this.events(model.events);
        }

        public final PublicEndpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(PublicEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(PublicEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final Map<String, Event.Builder> getEvents() {
            return this.events != null ? CollectionUtils.mapValues(this.events, Event::toBuilder) : null;
        }

        @Override
        public final Builder events(Map<String, Event> events) {
            this.events = MapOfEventCopier.copy(events);
            return this;
        }

        public final void setEvents(Map<String, Event.BuilderImpl> events) {
            this.events = MapOfEventCopier.copyFromBuilder(events);
        }

        public EventsBatch build() {
            return new EventsBatch(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventsBatch> {
        public Builder endpoint(PublicEndpoint var1);

        default public Builder endpoint(Consumer<PublicEndpoint.Builder> endpoint) {
            return this.endpoint((PublicEndpoint)((PublicEndpoint.Builder)PublicEndpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder events(Map<String, Event> var1);
    }
}

